﻿using System;
using System.Collections.Generic;
using System.Linq;

public class UriUtility
{
    public static bool IsValidPathSource(IReadOnlyList<string> pathSources, Uri uri)
    {
        if (pathSources == null || !pathSources.Any() || uri == null || string.IsNullOrEmpty(uri.LocalPath))
            return false;

        return pathSources.Contains(uri.LocalPath, StringComparer.OrdinalIgnoreCase);
    }
}